const fs = require('fs');
const path = require('path');

const CONFIG_DIR = path.join(__dirname, '..', 'config');
const CONFIG_PATH = path.join(CONFIG_DIR, 'posthog.json');

const PROJECT_API_KEY = process.env.POSTHOG_PROJECT_API_KEY;
const API_HOST = process.env.POSTHOG_API_HOST || 'https://app.posthog.com';

function exitWithUsage(message) {
  console.error(`\n${message}\n`);
  console.error('Expected environment variables:');
  console.error('  - POSTHOG_PROJECT_API_KEY (required)');
  console.error('  - POSTHOG_API_HOST (optional, defaults to https://app.posthog.com)\n');
  console.error('Example:');
  console.error('  POSTHOG_PROJECT_API_KEY=phc_xxx npm run setup:posthog\n');
  process.exit(1);
}

if (!PROJECT_API_KEY) {
  exitWithUsage('Missing POSTHOG_PROJECT_API_KEY.');
}

fs.mkdirSync(CONFIG_DIR, { recursive: true });

const payload = {
  projectApiKey: PROJECT_API_KEY,
  apiHost: API_HOST
};

fs.writeFileSync(CONFIG_PATH, JSON.stringify(payload, null, 2));

console.log(`PostHog configuration written to ${path.relative(process.cwd(), CONFIG_PATH)}`);

